<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db = getDB();

// Get user data
$uid  = $_SESSION['user_id'];
$stmt = $db->prepare("SELECT * FROM users WHERE id=?");
$stmt->bind_param('i', $uid);
$stmt->execute();
$currentUser = $stmt->get_result()->fetch_assoc();

// Get order count
$oResult = $db->query("SELECT COUNT(*) as c FROM orders WHERE user_id=$uid");
$orderCount = $oResult->fetch_assoc()['c'] ?? 0;

$currentPage = basename($_SERVER['PHP_SELF'], '.php');
$initials    = strtoupper(implode('', array_map(fn($w) => $w[0], explode(' ', $currentUser['name']))));

function navItem($href, $icon, $label, $current, $badge = '') {
    $active = strpos($current, $href) !== false ? 'active' : '';
    $badgeHtml = $badge ? "<span class='sidebar-badge'>$badge</span>" : '';
    echo "<a href='/client/$href' class='sidebar-item $active'>$icon <span>$label</span>$badgeHtml</a>";
}
?>
<div class="sidebar" id="sidebar">
  <div class="sidebar-logo">
    <div class="sidebar-logo-text">ProCRM</div>
    <div class="sidebar-logo-sub">Client Portal</div>
  </div>
  <nav class="sidebar-nav">
    <div class="sidebar-section">Main</div>
    <?php navItem('dashboard.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="3" y="3" width="7" height="7" rx="1"/><rect x="14" y="3" width="7" height="7" rx="1"/><rect x="3" y="14" width="7" height="7" rx="1"/><rect x="14" y="14" width="7" height="7" rx="1"/></svg>', 'Dashboard', $currentPage); ?>
    <?php navItem('services.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 2l2 7h7l-5.5 4 2 7L12 16l-5.5 4 2-7L3 9h7z"/></svg>', 'Services', $currentPage); ?>
    <?php navItem('orders.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/></svg>', 'My Orders', $currentPage, $orderCount > 0 ? $orderCount : ''); ?>

    <div class="sidebar-section">Account</div>
    <?php navItem('profile.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M20 21v-2a4 4 0 00-4-4H8a4 4 0 00-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>', 'Profile', $currentPage); ?>
    <?php navItem('security.php', '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>', 'Security & 2FA', $currentPage); ?>

    <div style="margin-top:auto;padding: 0 0 4px;">
      <a href="/client/logout.php" class="sidebar-item" style="color:var(--danger)">
        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M9 21H5a2 2 0 01-2-2V5a2 2 0 012-2h4M16 17l5-5-5-5M21 12H9"/></svg>
        <span>Logout</span>
      </a>
    </div>
  </nav>
  <div class="sidebar-footer">
    <div class="sidebar-user">
      <div class="sidebar-avatar"><?= htmlspecialchars($initials) ?></div>
      <div class="sidebar-user-info">
        <div class="sidebar-user-name"><?= htmlspecialchars($currentUser['name']) ?></div>
        <div class="sidebar-user-role">Client</div>
      </div>
    </div>
  </div>
</div>
<div class="sidebar-overlay" id="sidebarOverlay"></div>
