<?php
require_once __DIR__ . '/../includes/functions.php';
requireLogin();
$db  = getDB();
$uid = $_SESSION['user_id'];

// Fetch data
$categories  = $db->query("SELECT * FROM service_categories WHERE is_active=1 ORDER BY sort_order")->fetch_all(MYSQLI_ASSOC);
$services    = $db->query("SELECT s.*, sc.slug as cat_slug FROM services s JOIN service_categories sc ON s.category_id=sc.id WHERE s.is_active=1 ORDER BY s.sort_order")->fetch_all(MYSQLI_ASSOC);
$discounts   = $db->query("SELECT * FROM discount_options WHERE is_active=1 ORDER BY amount")->fetch_all(MYSQLI_ASSOC);
$payPlans    = $db->query("SELECT * FROM payment_plans WHERE is_active=1")->fetch_all(MYSQLI_ASSOC);
$settings    = getSettings();

// Handle order submission
$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $sid     = (int)($_POST['service_id'] ?? 0);
    $plan    = in_array($_POST['payment_plan'] ?? '', ['prepay','postpay']) ? $_POST['payment_plan'] : null;
    $payMeth = in_array($_POST['payment_method'] ?? '', ['usdt','upi']) ? $_POST['payment_method'] : '';
    $discount= (float)($_POST['discount'] ?? 0);
    $total   = (float)($_POST['total_amount'] ?? 0);
    $numCls  = (int)($_POST['num_classes'] ?? 0);

    if (!$sid) { $error = 'Please select a service.'; }
    elseif (!$payMeth) { $error = 'Please select a payment method.'; }
    elseif (empty($_FILES['screenshot']['name'])) { $error = 'Please upload your payment screenshot.'; }
    else {
        // Get service
        $sStmt = $db->prepare("SELECT * FROM services WHERE id=?");
        $sStmt->bind_param('i', $sid);
        $sStmt->execute();
        $svc = $sStmt->get_result()->fetch_assoc();

        if (!$svc) { $error = 'Invalid service selected.'; }
        else {
            $sub = $svc['is_training'] ? ($svc['price_per_class'] * max(1, $numCls)) : $svc['base_price'];
            if ($plan === 'postpay' && !$svc['is_training']) $sub += $svc['postpay_addon'];
            $tot = max(0, $sub - $discount);

            // Upload screenshot
            $screenshot = uploadFile($_FILES['screenshot'], 'uploads/payments');
            if (!$screenshot) { $error = 'Failed to upload screenshot. Ensure file is an image/PDF under 10MB.'; }
            else {
                $stmt = $db->prepare("INSERT INTO orders (user_id,service_id,payment_plan,num_classes,discount_amount,subtotal,total_amount,payment_method,payment_screenshot) VALUES (?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('iisiiddss', $uid, $sid, $plan, $numCls, $discount, $sub, $tot, $payMeth, $screenshot);
                if ($stmt->execute()) {
                    $oid = $db->insert_id;
                    // Save training dates
                    if (!empty($_POST['class_dates'])) {
                        $dStmt = $db->prepare("INSERT INTO training_dates (order_id, class_date) VALUES (?,?)");
                        foreach ($_POST['class_dates'] as $d) {
                            $date = sanitize($d);
                            if ($date) $dStmt->bind_param('is', $oid, $date) && $dStmt->execute();
                        }
                    }

                    // Email notification
                    $uEmail = $_SESSION['user_email'];
                    $uName  = $_SESSION['user_name'];
                    $oidFmt = '#' . str_pad($oid, 4, '0', STR_PAD_LEFT);
                    $content = "<h2>Order Received!</h2>
                        <p>Hi <strong>$uName</strong>, your order <strong>$oidFmt</strong> has been received and is pending review.</p>
                        <div class='code-box'>
                          <p>Service: {$svc['name']}</p>
                          <p>Total: \$$tot</p>
                          <p>Method: " . strtoupper($payMeth) . "</p>
                        </div>
                        <p>You'll be notified once your order is confirmed.</p>";
                    sendEmail($uEmail, "ProCRM — Order $oidFmt Received", emailTemplate('Order Confirmed', $content));

                    setFlash('success', "Order $oidFmt placed successfully! You'll be notified once confirmed.");
                    header('Location: /client/orders.php');
                    exit;
                } else {
                    $error = 'Failed to place order. Please try again.';
                }
            }
        }
    }
}

// Group services by category
$svcByCategory = [];
foreach ($services as $s) {
    $svcByCategory[$s['cat_slug']][] = $s;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Services — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/client-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Services</span>
    </div>

    <div class="page">
      <?= renderFlash() ?>
      <?php if ($error): ?><div class="flash flash-error"><span class="flash-icon">✕</span> <?= htmlspecialchars($error) ?></div><?php endif; ?>

      <div class="page-header">
        <h2>Our Services</h2>
        <p>Select a service and complete your order below.</p>
      </div>

      <!-- Category Tabs -->
      <div class="services-tabs">
        <?php foreach ($categories as $i => $cat): ?>
          <button class="service-tab <?= $i === 0 ? 'active' : '' ?>" data-target="<?= $cat['slug'] ?>">
            <?= htmlspecialchars($cat['name']) ?>
          </button>
        <?php endforeach; ?>
      </div>

      <form method="POST" enctype="multipart/form-data" id="mainOrderForm">
        <input type="hidden" name="service_id" id="service_id">
        <input type="hidden" name="total_amount" id="total_amount" value="0">
        <input type="hidden" name="num_classes" id="num_classes_val" value="0">

        <!-- Category Panes -->
        <?php foreach ($categories as $i => $cat): ?>
        <div class="services-tab-pane" data-tab="<?= $cat['slug'] ?>" style="display:<?= $i === 0 ? 'block' : 'none' ?>">

          <?php if ($cat['slug'] === 'campaign'): ?>
          <!-- CAMPAIGN SERVICES -->
          <div class="services-grid">
            <?php foreach ($svcByCategory['campaign'] ?? [] as $svc): ?>
            <div class="service-card" data-id="<?= $svc['id'] ?>" data-price="<?= $svc['base_price'] ?>" data-training="0" data-postpay-addon="<?= $svc['postpay_addon'] ?>">
              <div>
                <div class="label-caps">Campaign Setup</div>
                <div class="service-card-name" style="margin-top:8px"><?= htmlspecialchars($svc['name']) ?></div>
              </div>
              <div class="service-card-price">$<?= number_format($svc['base_price'], 0) ?> <span>/ setup</span></div>
              <div style="font-size:12px;color:var(--text-muted);border-top:1px solid var(--border);padding-top:12px">
                PostPay: $<?= number_format($svc['base_price'] + $svc['postpay_addon'], 0) ?>
              </div>
            </div>
            <?php endforeach; ?>
          </div>

          <!-- Payment Plans (campaign) -->
          <div id="campaignPlanSection" style="margin-top:28px;display:none">
            <div class="card">
              <div class="card-header"><div class="card-title">Payment Plan</div></div>
              <div class="plan-toggle">
                <?php
                $prepayTerms  = '';
                $postpayTerms = '';
                foreach ($payPlans as $pp) {
                    if ($pp['plan_type'] === 'prepay') $prepayTerms = $pp['terms'];
                    if ($pp['plan_type'] === 'postpay') $postpayTerms = $pp['terms'];
                }
                ?>
                <div class="plan-option">
                  <input type="radio" name="payment_plan" value="prepay" id="plan_prepay">
                  <label for="plan_prepay" class="plan-label">
                    <div class="plan-label-title">Pre Pay</div>
                    <div class="plan-label-price" id="prepayPrice">$—</div>
                    <div class="plan-label-note">Standard pricing</div>
                  </label>
                </div>
                <div class="plan-option">
                  <input type="radio" name="payment_plan" value="postpay" id="plan_postpay">
                  <label for="plan_postpay" class="plan-label">
                    <div class="plan-label-title">Post Pay</div>
                    <div class="plan-label-price" id="postpayPrice">$—</div>
                    <div class="plan-label-note">+$100 per service</div>
                  </label>
                </div>
              </div>
              <div id="planTermsBox" style="background:var(--black);border:1px solid var(--border);border-radius:8px;padding:16px;font-size:13px;color:var(--text-muted);line-height:1.7;display:none;">
                <span class="label-caps" style="display:block;margin-bottom:8px">Terms & Conditions</span>
                <span id="planTermsText"></span>
              </div>
            </div>
          </div>

          <?php elseif ($cat['slug'] === 'training'): ?>
          <!-- TRAINING SERVICES -->
          <div class="services-grid">
            <?php foreach ($svcByCategory['training'] ?? [] as $svc): ?>
            <div class="service-card" data-id="<?= $svc['id'] ?>" data-price="<?= $svc['price_per_class'] ?>" data-training="1" data-price-per-class="<?= $svc['price_per_class'] ?>" data-classes="<?= $svc['classes_count'] ?>">
              <div>
                <div class="label-caps">Training</div>
                <div class="service-card-name" style="margin-top:8px"><?= htmlspecialchars($svc['name']) ?></div>
              </div>
              <div style="display:flex;align-items:baseline;gap:8px">
                <div class="service-card-price">$<?= number_format($svc['price_per_class'], 0) ?> <span>/ class</span></div>
              </div>
              <div style="font-size:12px;color:var(--text-muted);border-top:1px solid var(--border);padding-top:12px">
                <?= $svc['classes_count'] ?> classes recommended
              </div>
            </div>
            <?php endforeach; ?>
          </div>

          <!-- Training Date Selector -->
          <div id="trainingDateSection" style="margin-top:28px;display:none">
            <div class="card">
              <div class="card-header">
                <div class="card-title">Select Class Dates</div>
                <button type="button" class="btn btn-outline btn-sm" id="addDateBtn">+ Add Date</button>
              </div>
              <div id="datesContainer">
                <div class="date-input-group">
                  <input type="date" name="class_dates[]" class="form-control" min="<?= date('Y-m-d', strtotime('+1 day')) ?>" required>
                  <button type="button" class="remove-btn" onclick="this.closest('.date-input-group').remove();updatePriceSummary();">✕</button>
                </div>
              </div>
              <p class="form-hint mt-8">Number of dates selected = number of classes booked</p>
            </div>
          </div>

          <!-- Discount (training only) -->
          <div id="discountSection" style="margin-top:20px;display:none">
            <div class="card">
              <div class="card-header"><div class="card-title">Apply Discount</div></div>
              <p class="text-muted" style="font-size:13px;margin-bottom:16px">Select an optional discount to apply to your total.</p>
              <div class="discount-options">
                <label class="discount-option">
                  <input type="radio" name="discount" value="0" checked>
                  <span class="discount-label" style="font-size:12px;color:var(--text-muted)">None</span>
                </label>
                <?php foreach ($discounts as $d): ?>
                <label class="discount-option">
                  <input type="radio" name="discount" value="<?= $d['amount'] ?>">
                  <span class="discount-label">-$<?= number_format($d['amount'], 0) ?></span>
                </label>
                <?php endforeach; ?>
              </div>
            </div>
          </div>
          <?php endif; ?>

        </div>
        <?php endforeach; ?>

        <!-- Order Form (shown after service selection) -->
        <div id="orderForm" style="display:none;margin-top:28px">
          <!-- Price Summary -->
          <div class="card" style="margin-bottom:20px">
            <div class="card-header"><div class="card-title">Order Summary</div></div>
            <div class="price-summary">
              <div class="price-row">
                <span>Service</span>
                <span id="summarySubtotal">$0.00</span>
              </div>
              <div class="price-row" id="summaryAddonRow" style="display:none">
                <span>Post Pay Addon</span>
                <span id="summaryAddon">$0.00</span>
              </div>
              <div class="price-row discount" id="summaryDiscountRow" style="display:none">
                <span>Discount</span>
                <span id="summaryDiscount">-$0.00</span>
              </div>
              <div class="price-row divider total">
                <span>Total to Pay</span>
                <span id="summaryTotal">$0.00</span>
              </div>
            </div>
          </div>

          <!-- Payment Method -->
          <div class="card" style="margin-bottom:20px">
            <div class="card-header"><div class="card-title">Payment Method</div></div>
            <div style="display:flex;gap:12px;margin-bottom:20px">
              <label class="plan-option" style="flex:1">
                <input type="radio" name="payment_method" value="usdt" checked>
                <span class="plan-label">
                  <div class="plan-label-title">USDT</div>
                  <div style="font-size:12px;color:var(--text-muted);margin-top:4px">Cryptocurrency</div>
                </span>
              </label>
              <label class="plan-option" style="flex:1">
                <input type="radio" name="payment_method" value="upi">
                <span class="plan-label">
                  <div class="plan-label-title">UPI</div>
                  <div style="font-size:12px;color:var(--text-muted);margin-top:4px">India payments</div>
                </span>
              </label>
            </div>

            <div class="payment-detail" id="payment_usdt">
              <div style="background:var(--black);border:1px solid var(--border);border-radius:8px;padding:16px">
                <div class="label-caps" style="margin-bottom:8px">USDT Address (TRC20)</div>
                <div class="td-mono" style="font-size:13px;word-break:break-all;color:var(--white)"><?= htmlspecialchars($settings['usdt_address'] ?? 'Contact admin for address') ?></div>
              </div>
            </div>

            <div class="payment-detail" id="payment_upi" style="display:none">
              <div style="background:var(--black);border:1px solid var(--border);border-radius:8px;padding:16px">
                <div class="label-caps" style="margin-bottom:8px">UPI ID</div>
                <div class="td-mono" style="font-size:13px;color:var(--white)"><?= htmlspecialchars($settings['upi_id'] ?? 'Contact admin for UPI ID') ?></div>
              </div>
            </div>
          </div>

          <!-- Upload Screenshot -->
          <div class="card" style="margin-bottom:20px">
            <div class="card-header"><div class="card-title">Payment Proof</div></div>
            <div class="upload-area">
              <input type="file" name="screenshot" id="payment_screenshot" accept="image/*,.pdf">
              <div class="upload-icon">📤</div>
              <div class="upload-text"><strong>Click to upload</strong> or drag & drop<br>JPG, PNG, PDF up to 10MB</div>
            </div>
            <div id="uploadPreview"></div>
          </div>

          <button type="submit" class="btn btn-primary btn-full btn-lg">Submit Order</button>
        </div>

      </form>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
<script>
const prepayTerms  = <?= json_encode($prepayTerms ?? '') ?>;
const postpayTerms = <?= json_encode($postpayTerms ?? '') ?>;

// Override update to also show/hide plan and training sections
const _origUpdate = window.updatePriceSummary;
window.updatePriceSummary = function() {
  _origUpdate && _origUpdate();
  const selected = document.querySelector('.service-card.selected');
  if (!selected) return;

  const isTraining = selected.dataset.training === '1';
  const basePrice  = parseFloat(selected.dataset.price || 0);
  const addon      = parseFloat(selected.dataset.postpayAddon || 100);

  // Toggle sections
  document.getElementById('campaignPlanSection').style.display = isTraining ? 'none' : 'block';
  document.getElementById('trainingDateSection').style.display  = isTraining ? 'block' : 'none';
  document.getElementById('discountSection').style.display      = isTraining ? 'block' : 'none';

  // Update prepay/postpay prices
  const pp = document.getElementById('prepayPrice');
  const po = document.getElementById('postpayPrice');
  if (pp) pp.textContent = '$' + basePrice.toFixed(0);
  if (po) po.textContent = '$' + (basePrice + addon).toFixed(0);
};

// Show plan terms
document.querySelectorAll('input[name="payment_plan"]').forEach(r => {
  r.addEventListener('change', function() {
    const box  = document.getElementById('planTermsBox');
    const text = document.getElementById('planTermsText');
    box.style.display = 'block';
    text.textContent = this.value === 'prepay' ? prepayTerms : postpayTerms;
  });
});
</script>
</body>
</html>
