<?php
require_once __DIR__ . '/../includes/functions.php';

if (isLoggedIn()) { header('Location: /client/dashboard.php'); exit; }

$error = '';
$step = 'login'; // login | 2fa

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db = getDB();

    if (isset($_POST['step']) && $_POST['step'] === '2fa') {
        // Verify 2FA code
        $code = sanitize($_POST['code'] ?? '');
        $uid  = $_SESSION['pending_2fa_user'] ?? 0;

        $stmt = $db->prepare("SELECT * FROM users WHERE id=? AND two_fa_code=? AND two_fa_expires > NOW()");
        $stmt->bind_param('is', $uid, $code);
        $stmt->execute();
        $user = $stmt->get_result()->fetch_assoc();

        if ($user) {
            // Clear code
            $db->query("UPDATE users SET two_fa_code=NULL, two_fa_expires=NULL WHERE id=$uid");
            $_SESSION['user_id']   = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_email']= $user['email'];
            $_SESSION['role']      = 'client';
            unset($_SESSION['pending_2fa_user']);
            header('Location: /client/dashboard.php');
            exit;
        } else {
            $step  = '2fa';
            $error = 'Invalid or expired code. Please try again.';
        }

    } else {
        // Login step
        $email    = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
        $password = $_POST['password'] ?? '';

        if (!$email || !$password) {
            $error = 'Please enter email and password.';
        } else {
            $stmt = $db->prepare("SELECT * FROM users WHERE email=?");
            $stmt->bind_param('s', $email);
            $stmt->execute();
            $user = $stmt->get_result()->fetch_assoc();

            if (!$user) {
                $error = 'No account found with this email.';
            } elseif ($user['status'] === 'pending') {
                $error = 'Your account is pending admin approval.';
            } elseif ($user['status'] === 'disapproved') {
                $error = 'Your account has been disapproved. Contact support.';
            } elseif (!password_verify($password, $user['password'])) {
                $error = 'Incorrect password.';
            } else {
                if ($user['two_fa_enabled']) {
                    // Send 2FA code
                    $code    = generateCode(6);
                    $expires = date('Y-m-d H:i:s', strtotime('+10 minutes'));
                    $uid     = $user['id'];
                    $db->query("UPDATE users SET two_fa_code='$code', two_fa_expires='$expires' WHERE id=$uid");

                    // Send via email
                    $content = "<h2>Your Login Code</h2>
                        <p>Hi <strong>{$user['name']}</strong>, use the code below to complete your login.</p>
                        <div class='code-box'><div class='code'>$code</div></div>
                        <p>This code expires in 10 minutes.</p>";
                    sendEmail($user['email'], 'ProCRM — Login Verification Code', emailTemplate('2FA Code', $content));

                    // If WhatsApp configured, send there too (placeholder)
                    if ($user['whatsapp']) {
                        // WhatsApp via Twilio: would go here
                    }

                    $_SESSION['pending_2fa_user'] = $user['id'];
                    $step = '2fa';
                } else {
                    $_SESSION['user_id']    = $user['id'];
                    $_SESSION['user_name']  = $user['name'];
                    $_SESSION['user_email'] = $user['email'];
                    $_SESSION['role']       = 'client';
                    header('Location: /client/dashboard.php');
                    exit;
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="auth-wrapper">
  <div class="auth-brand">
    <div class="auth-brand-logo">ProCRM</div>
    <div class="auth-brand-tagline">Client Management Platform</div>
    <div class="auth-brand-desc">Professional campaign management and digital marketing training services at your fingertips.</div>
  </div>
  <div class="auth-form-area">
    <div class="auth-box">

      <?php if ($step === '2fa'): ?>
      <div class="auth-header">
        <h2>Verify Identity</h2>
        <p>We've sent a 6-digit code to your email<?= isset($_SESSION['pending_2fa_user']) && !empty($_SESSION['pending_whatsapp']) ? ' & WhatsApp' : '' ?>.</p>
      </div>
      <?php if ($error): ?>
        <div class="flash flash-error"><span class="flash-icon">✕</span> <?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <form method="POST">
        <input type="hidden" name="step" value="2fa">
        <div class="form-group">
          <label class="form-label">Verification Code</label>
          <input type="text" name="code" class="form-control" placeholder="000000" maxlength="6" style="font-size:24px;letter-spacing:8px;text-align:center;font-family:var(--font-mono)" autofocus required>
        </div>
        <button type="submit" class="btn btn-primary btn-full btn-lg">Verify & Login</button>
        <p class="text-center text-muted mt-16" style="font-size:13px">
          <a href="/client/login.php" style="color:var(--white)">← Back to login</a>
        </p>
      </form>

      <?php else: ?>
      <div class="auth-header">
        <h2>Welcome Back</h2>
        <p>Sign in to access your dashboard</p>
      </div>
      <?php if ($error): ?>
        <div class="flash flash-error"><span class="flash-icon">✕</span> <?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <form method="POST">
        <div class="form-group">
          <label class="form-label">Email Address</label>
          <input type="email" name="email" class="form-control" placeholder="you@example.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" autofocus required>
        </div>
        <div class="form-group">
          <label class="form-label">Password</label>
          <div style="position:relative;display:flex;align-items:center;">
            <input type="password" name="password" class="form-control" placeholder="Your password" style="padding-right:48px" required>
            <button type="button" class="password-toggle" style="position:absolute;right:12px;background:none;border:none;color:var(--text-muted);font-size:16px;cursor:pointer;">👁</button>
          </div>
        </div>

        <div style="display:flex;justify-content:flex-end;margin-bottom:20px;">
          <a href="/client/forgot-password.php" style="font-size:13px;color:var(--text-muted)">Forgot password?</a>
        </div>

        <button type="submit" class="btn btn-primary btn-full btn-lg">Sign In</button>

        <p class="text-center text-muted mt-16" style="font-size:14px">
          Don't have an account? <a href="/client/register.php" style="color:var(--white)">Register</a>
        </p>
      </form>
      <?php endif; ?>

    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
