// ProCRM Main JS

(function() {
  'use strict';

  // ─── Sidebar Mobile Toggle ────────────────────────────────────
  const sidebar = document.getElementById('sidebar');
  const overlay = document.getElementById('sidebarOverlay');
  const toggleBtn = document.getElementById('sidebarToggle');

  function openSidebar() {
    sidebar?.classList.add('open');
    overlay?.classList.add('open');
    document.body.style.overflow = 'hidden';
  }

  function closeSidebar() {
    sidebar?.classList.remove('open');
    overlay?.classList.remove('open');
    document.body.style.overflow = '';
  }

  toggleBtn?.addEventListener('click', openSidebar);
  overlay?.addEventListener('click', closeSidebar);

  // ─── Flash Auto Dismiss ───────────────────────────────────────
  document.querySelectorAll('.flash').forEach(el => {
    setTimeout(() => {
      el.style.transition = 'all 0.4s ease';
      el.style.opacity = '0';
      el.style.transform = 'translateY(-10px)';
      setTimeout(() => el.remove(), 400);
    }, 5000);
  });

  // ─── Service Selection (Client) ──────────────────────────────
  document.querySelectorAll('.service-card[data-id]').forEach(card => {
    card.addEventListener('click', function() {
      const tab = this.closest('.services-tab-pane')?.dataset.tab;
      if (tab === 'campaign') {
        document.querySelectorAll('[data-tab="campaign"] .service-card').forEach(c => c.classList.remove('selected'));
      } else {
        document.querySelectorAll('[data-tab="training"] .service-card').forEach(c => c.classList.remove('selected'));
      }
      this.classList.add('selected');

      // Update hidden input
      const idInput = document.getElementById('service_id');
      if (idInput) idInput.value = this.dataset.id;

      // Show order form
      const form = document.getElementById('orderForm');
      if (form) {
        form.style.display = 'block';
        form.scrollIntoView({ behavior: 'smooth', block: 'start' });
      }

      // Update price display
      updatePriceSummary();
    });
  });

  // ─── Service Tabs ─────────────────────────────────────────────
  document.querySelectorAll('.service-tab').forEach(tab => {
    tab.addEventListener('click', function() {
      document.querySelectorAll('.service-tab').forEach(t => t.classList.remove('active'));
      document.querySelectorAll('.services-tab-pane').forEach(p => p.style.display = 'none');
      this.classList.add('active');
      const target = document.querySelector(`.services-tab-pane[data-tab="${this.dataset.target}"]`);
      if (target) target.style.display = 'block';
    });
  });

  // Show first tab by default
  const firstTab = document.querySelector('.service-tab');
  firstTab?.click();

  // ─── Payment Plan Toggle ──────────────────────────────────────
  document.querySelectorAll('input[name="payment_plan"]').forEach(radio => {
    radio.addEventListener('change', updatePriceSummary);
  });

  // ─── Discount Selection ───────────────────────────────────────
  document.querySelectorAll('input[name="discount"]').forEach(radio => {
    radio.addEventListener('change', updatePriceSummary);
  });

  // ─── Class Count Input ────────────────────────────────────────
  document.getElementById('num_classes')?.addEventListener('input', updatePriceSummary);

  // ─── Training Date Picker ─────────────────────────────────────
  const addDateBtn = document.getElementById('addDateBtn');
  const datesContainer = document.getElementById('datesContainer');

  if (addDateBtn && datesContainer) {
    addDateBtn.addEventListener('click', () => {
      const count = datesContainer.querySelectorAll('.date-input-group').length;
      const div = document.createElement('div');
      div.className = 'date-input-group mt-8';
      div.innerHTML = `
        <input type="date" name="class_dates[]" class="form-control" min="${new Date().toISOString().split('T')[0]}" required>
        <button type="button" class="remove-btn" onclick="this.closest('.date-input-group').remove(); updatePriceSummary();">✕</button>
      `;
      datesContainer.appendChild(div);
      updatePriceSummary();
    });
  }

  // ─── Price Summary Calculator ─────────────────────────────────
  window.updatePriceSummary = function() {
    const selected = document.querySelector('.service-card.selected');
    if (!selected) return;

    const basePrice = parseFloat(selected.dataset.price || 0);
    const isTraining = selected.dataset.training === '1';
    const pricePerClass = parseFloat(selected.dataset.pricePerClass || 0);

    const plan = document.querySelector('input[name="payment_plan"]:checked')?.value;
    const discount = parseFloat(document.querySelector('input[name="discount"]:checked')?.value || 0);

    let subtotal = basePrice;
    let postpayAddon = 0;

    if (isTraining) {
      const dates = document.querySelectorAll('input[name="class_dates[]"]');
      const numClasses = dates.length || 1;
      subtotal = pricePerClass * numClasses;
      document.getElementById('num_classes_val')?.setAttribute('value', numClasses);

      // Update display
      const el = document.getElementById('classCountDisplay');
      if (el) el.textContent = numClasses;
    } else {
      if (plan === 'postpay') {
        postpayAddon = 100;
      }
    }

    const total = subtotal + postpayAddon - discount;

    // Update summary UI
    const els = {
      subtotal: document.getElementById('summarySubtotal'),
      addon: document.getElementById('summaryAddon'),
      addonRow: document.getElementById('summaryAddonRow'),
      discount: document.getElementById('summaryDiscount'),
      discountRow: document.getElementById('summaryDiscountRow'),
      total: document.getElementById('summaryTotal'),
    };

    if (els.subtotal) els.subtotal.textContent = '$' + subtotal.toFixed(2);
    if (els.addon) els.addon.textContent = '$' + postpayAddon.toFixed(2);
    if (els.addonRow) els.addonRow.style.display = postpayAddon > 0 ? 'flex' : 'none';
    if (els.discount) els.discount.textContent = '-$' + discount.toFixed(2);
    if (els.discountRow) els.discountRow.style.display = discount > 0 ? 'flex' : 'none';
    if (els.total) els.total.textContent = '$' + Math.max(0, total).toFixed(2);

    // Update hidden total input
    const totalInput = document.getElementById('total_amount');
    if (totalInput) totalInput.value = Math.max(0, total).toFixed(2);
  };

  // ─── Upload Preview ───────────────────────────────────────────
  const fileInput = document.getElementById('payment_screenshot');
  if (fileInput) {
    fileInput.addEventListener('change', function() {
      const preview = document.getElementById('uploadPreview');
      if (!preview) return;
      if (this.files[0]) {
        const reader = new FileReader();
        reader.onload = e => {
          preview.innerHTML = `<img src="${e.target.result}" style="max-height:200px;border-radius:8px;margin-top:12px;">`;
        };
        reader.readAsDataURL(this.files[0]);
      }
    });

    // Drag & drop
    const uploadArea = document.querySelector('.upload-area');
    if (uploadArea) {
      ['dragenter', 'dragover'].forEach(e => {
        uploadArea.addEventListener(e, ev => { ev.preventDefault(); uploadArea.classList.add('dragover'); });
      });
      ['dragleave', 'drop'].forEach(e => {
        uploadArea.addEventListener(e, ev => { ev.preventDefault(); uploadArea.classList.remove('dragover'); });
      });
      uploadArea.addEventListener('drop', ev => {
        if (ev.dataTransfer.files[0]) {
          fileInput.files = ev.dataTransfer.files;
          fileInput.dispatchEvent(new Event('change'));
        }
      });
    }
  }

  // ─── Modals ───────────────────────────────────────────────────
  document.querySelectorAll('[data-modal]').forEach(btn => {
    btn.addEventListener('click', function() {
      const modal = document.getElementById(this.dataset.modal);
      if (modal) modal.style.display = 'flex';
    });
  });

  document.querySelectorAll('.modal-close, [data-dismiss="modal"]').forEach(btn => {
    btn.addEventListener('click', function() {
      this.closest('.modal-backdrop').style.display = 'none';
    });
  });

  document.querySelectorAll('.modal-backdrop').forEach(bd => {
    bd.addEventListener('click', function(e) {
      if (e.target === this) this.style.display = 'none';
    });
  });

  // ─── Confirm Dialogs ──────────────────────────────────────────
  document.querySelectorAll('[data-confirm]').forEach(el => {
    el.addEventListener('click', function(e) {
      if (!confirm(this.dataset.confirm || 'Are you sure?')) {
        e.preventDefault();
      }
    });
  });

  // ─── Password Toggle ──────────────────────────────────────────
  document.querySelectorAll('.password-toggle').forEach(btn => {
    btn.addEventListener('click', function() {
      const input = this.previousElementSibling;
      if (input.type === 'password') {
        input.type = 'text';
        this.textContent = '🙈';
      } else {
        input.type = 'password';
        this.textContent = '👁';
      }
    });
  });

  // ─── Table Search ─────────────────────────────────────────────
  document.querySelectorAll('[data-search-table]').forEach(input => {
    input.addEventListener('input', function() {
      const table = document.querySelector(this.dataset.searchTable);
      if (!table) return;
      const term = this.value.toLowerCase();
      table.querySelectorAll('tbody tr').forEach(row => {
        row.style.display = row.textContent.toLowerCase().includes(term) ? '' : 'none';
      });
    });
  });

  // ─── Payment Method Toggle ────────────────────────────────────
  document.querySelectorAll('input[name="payment_method"]').forEach(radio => {
    radio.addEventListener('change', function() {
      document.querySelectorAll('.payment-detail').forEach(d => d.style.display = 'none');
      const target = document.getElementById('payment_' + this.value);
      if (target) target.style.display = 'block';
    });
  });

  // Show first payment method
  const firstPayMethod = document.querySelector('input[name="payment_method"]');
  firstPayMethod?.dispatchEvent(new Event('change'));

})();
