<?php
require_once __DIR__ . '/../includes/functions.php';

if (isAdminLoggedIn()) { header('Location: /admin/dashboard.php'); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db    = getDB();
    $email = filter_var($_POST['email'] ?? '', FILTER_VALIDATE_EMAIL);
    $pass  = $_POST['password'] ?? '';

    if (!$email || !$pass) {
        $error = 'Enter email and password.';
    } else {
        $stmt = $db->prepare("SELECT * FROM admins WHERE email=?");
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $admin = $stmt->get_result()->fetch_assoc();

        if ($admin && password_verify($pass, $admin['password'])) {
            $_SESSION['admin_id']   = $admin['id'];
            $_SESSION['admin_name'] = $admin['name'];
            $_SESSION['role']       = 'admin';
            header('Location: /admin/dashboard.php');
            exit;
        } else {
            $error = 'Invalid credentials.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Login — ProCRM</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="auth-wrapper">
  <div class="auth-brand" style="background:var(--black);color:var(--white);border-right:1px solid var(--border)">
    <div style="position:relative;z-index:1;text-align:center">
      <div class="auth-brand-logo" style="color:var(--white)">ProCRM</div>
      <div class="auth-brand-tagline">Admin Console</div>
      <div class="auth-brand-desc" style="color:var(--text-muted)">Restricted access. Authorized administrators only.</div>
    </div>
  </div>
  <div class="auth-form-area">
    <div class="auth-box">
      <div class="auth-header">
        <h2>Admin Login</h2>
        <p>Enter your administrator credentials</p>
      </div>
      <?php if ($error): ?>
        <div class="flash flash-error"><span class="flash-icon">✕</span> <?= htmlspecialchars($error) ?></div>
      <?php endif; ?>
      <form method="POST">
        <div class="form-group">
          <label class="form-label">Admin Email</label>
          <input type="email" name="email" class="form-control" placeholder="admin@crm.com" value="<?= htmlspecialchars($_POST['email'] ?? '') ?>" autofocus required>
        </div>
        <div class="form-group">
          <label class="form-label">Password</label>
          <div style="position:relative;display:flex;align-items:center;">
            <input type="password" name="password" class="form-control" placeholder="Admin password" style="padding-right:48px" required>
            <button type="button" class="password-toggle" style="position:absolute;right:12px;background:none;border:none;color:var(--text-muted);font-size:16px;cursor:pointer;">👁</button>
          </div>
        </div>
        <button type="submit" class="btn btn-primary btn-full btn-lg">Sign In to Admin</button>
        <p class="text-center mt-16" style="font-size:13px;color:var(--text-muted)">
          <a href="/client/login.php" style="color:var(--text-muted)">← Client Portal</a>
        </p>
      </form>
    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
