<?php
require_once __DIR__ . '/../includes/functions.php';
requireAdmin();
$db = getDB();

// Quick actions
if (isset($_GET['approve'])) {
    $id = (int)$_GET['approve'];
    $db->query("UPDATE users SET status='approved' WHERE id=$id");
    // Notify user
    $u = $db->query("SELECT * FROM users WHERE id=$id")->fetch_assoc();
    if ($u) {
        $content = "<h2>Account Approved!</h2><p>Hi <strong>{$u['name']}</strong>, your ProCRM account has been approved!</p>
            <p><a href='http://{$_SERVER['HTTP_HOST']}/client/login.php' style='display:inline-block;background:#fff;color:#000;padding:14px 32px;border-radius:4px;text-decoration:none;font-weight:700;margin:16px 0;text-transform:uppercase;letter-spacing:1px'>Login Now</a></p>";
        sendEmail($u['email'], 'ProCRM — Account Approved!', emailTemplate('Welcome!', $content));
    }
    setFlash('success', 'Client approved and notified.');
    header('Location: /admin/clients.php');
    exit;
}

if (isset($_GET['disapprove'])) {
    $id = (int)$_GET['disapprove'];
    $db->query("UPDATE users SET status='disapproved' WHERE id=$id");
    setFlash('success', 'Client disapproved.');
    header('Location: /admin/clients.php');
    exit;
}

// Filters
$filter = $_GET['filter'] ?? 'all';
$where  = $filter !== 'all' ? "WHERE status='$filter'" : '';
$search = sanitize($_GET['search'] ?? '');
if ($search) {
    $s = $db->real_escape_string($search);
    $where = $where ? "$where AND (name LIKE '%$s%' OR email LIKE '%$s%')" : "WHERE (name LIKE '%$s%' OR email LIKE '%$s%')";
}

$clients = $db->query("SELECT u.*, (SELECT COUNT(*) FROM orders WHERE user_id=u.id) as order_count FROM users u $where ORDER BY u.created_at DESC")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Clients — ProCRM Admin</title>
<link rel="stylesheet" href="/assets/css/style.css">
</head>
<body>
<div class="layout">
  <?php include __DIR__ . '/../includes/admin-sidebar.php'; ?>
  <div class="main-content">
    <div class="topbar">
      <button class="topbar-toggle" id="sidebarToggle">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><line x1="3" y1="6" x2="21" y2="6"/><line x1="3" y1="12" x2="21" y2="12"/><line x1="3" y1="18" x2="21" y2="18"/></svg>
      </button>
      <span class="topbar-title">Clients</span>
    </div>
    <div class="page">
      <?= renderFlash() ?>
      <div class="page-header">
        <h2>Client Management</h2>
        <p>Approve, manage, and review all registered clients.</p>
      </div>

      <!-- Filters -->
      <div style="display:flex;flex-wrap:wrap;gap:12px;margin-bottom:20px;align-items:center">
        <form method="GET" style="flex:1;min-width:200px">
          <input type="text" name="search" class="form-control" placeholder="Search by name or email..." value="<?= htmlspecialchars($search) ?>" style="max-width:300px">
          <?php if ($filter !== 'all'): ?><input type="hidden" name="filter" value="<?= $filter ?>"><?php endif; ?>
        </form>
        <div style="display:flex;gap:6px;flex-wrap:wrap">
          <?php foreach (['all','pending','approved','disapproved'] as $f): ?>
          <a href="?filter=<?= $f ?>" class="btn <?= $filter === $f ? 'btn-primary' : 'btn-outline' ?> btn-sm"><?= ucfirst($f) ?></a>
          <?php endforeach; ?>
        </div>
      </div>

      <div class="card">
        <?php if (empty($clients)): ?>
          <div class="empty-state">
            <div class="empty-state-icon">👥</div>
            <div class="empty-state-title">No clients found</div>
          </div>
        <?php else: ?>
        <div class="table-wrap">
          <table>
            <thead>
              <tr>
                <th>Client</th>
                <th>Phone</th>
                <th>WhatsApp</th>
                <th>Telegram</th>
                <th>Orders</th>
                <th>Status</th>
                <th>Joined</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($clients as $c): ?>
              <tr>
                <td>
                  <div style="font-weight:600"><?= htmlspecialchars($c['name']) ?></div>
                  <div style="font-size:12px;color:var(--text-muted)"><?= htmlspecialchars($c['email']) ?></div>
                </td>
                <td class="text-muted" style="font-size:13px"><?= htmlspecialchars($c['phone']) ?></td>
                <td class="text-muted" style="font-size:13px"><?= htmlspecialchars($c['whatsapp'] ?? '—') ?></td>
                <td class="text-muted" style="font-size:13px"><?= htmlspecialchars($c['telegram_id'] ?? '—') ?></td>
                <td><span class="badge badge-pending" style="background:rgba(255,255,255,0.08);color:var(--white)"><?= $c['order_count'] ?></span></td>
                <td><span class="badge badge-<?= $c['status'] ?>"><?= ucfirst($c['status']) ?></span></td>
                <td class="text-muted" style="font-size:13px"><?= date('M j, Y', strtotime($c['created_at'])) ?></td>
                <td>
                  <div style="display:flex;gap:6px">
                    <?php if ($c['status'] !== 'approved'): ?>
                      <a href="?approve=<?= $c['id'] ?>" class="btn btn-success btn-sm" title="Approve">✓</a>
                    <?php endif; ?>
                    <?php if ($c['status'] !== 'disapproved'): ?>
                      <a href="?disapprove=<?= $c['id'] ?>" class="btn btn-danger btn-sm" data-confirm="Disapprove this client?" title="Disapprove">✕</a>
                    <?php endif; ?>
                    <button class="btn btn-outline btn-sm" data-modal="modal-client-<?= $c['id'] ?>">View</button>
                  </div>
                </td>
              </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <?php endif; ?>
      </div>

      <!-- Client Detail Modals -->
      <?php foreach ($clients as $c): ?>
      <div class="modal-backdrop" id="modal-client-<?= $c['id'] ?>" style="display:none">
        <div class="modal">
          <div class="modal-header">
            <div class="modal-title"><?= htmlspecialchars($c['name']) ?></div>
            <button class="modal-close" data-dismiss="modal">✕</button>
          </div>
          <div class="modal-body">
            <div style="display:grid;grid-template-columns:1fr 1fr;gap:16px">
              <div><div class="label-caps" style="margin-bottom:6px">Email</div><div><?= htmlspecialchars($c['email']) ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Phone</div><div><?= htmlspecialchars($c['phone']) ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">WhatsApp</div><div><?= htmlspecialchars($c['whatsapp'] ?? '—') ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Telegram</div><div><?= htmlspecialchars($c['telegram_id'] ?? '—') ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">2FA</div><div><?= $c['two_fa_enabled'] ? '✓ Enabled' : '✕ Disabled' ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Orders</div><div><?= $c['order_count'] ?></div></div>
              <div><div class="label-caps" style="margin-bottom:6px">Status</div><span class="badge badge-<?= $c['status'] ?>"><?= ucfirst($c['status']) ?></span></div>
              <div><div class="label-caps" style="margin-bottom:6px">Joined</div><div><?= date('M j, Y', strtotime($c['created_at'])) ?></div></div>
            </div>
          </div>
          <div class="modal-footer">
            <?php if ($c['status'] !== 'approved'): ?>
              <a href="?approve=<?= $c['id'] ?>" class="btn btn-success">Approve</a>
            <?php endif; ?>
            <?php if ($c['status'] !== 'disapproved'): ?>
              <a href="?disapprove=<?= $c['id'] ?>" class="btn btn-danger">Disapprove</a>
            <?php endif; ?>
            <button class="btn btn-outline" data-dismiss="modal">Close</button>
          </div>
        </div>
      </div>
      <?php endforeach; ?>

    </div>
  </div>
</div>
<script src="/assets/js/app.js"></script>
</body>
</html>
